@extends('frontend.layout.master')
@section('content')

<div class="MuiBox-root jss59">
  <div class="jss60 triageTabs">
    <div class="jss61">
      <div class="jss62">
        <h1 class="MuiTypography-root jss39 jss63 MuiTypography-body1">Discover Your Perfect Job: Matching Your Interests and Skills</h1>
        <form class="jss64 jss65">
          <div class="jss66 jss75">
            <div class="jss67 jss76 Red jss73">
              <div class="MuiTabs-root">
                <div class="MuiTabs-scroller MuiTabs-fixed" style="overflow:hidden">
                  <div class="MuiTabs-flexContainer" role="tablist"><button class="MuiButtonBase-root MuiTab-root MuiTab-textColorInherit Mui-selected" tabindex="0" type="button" role="tab" aria-selected="true"><span class="MuiTab-wrapper">Find Location</span><span class="jss77 jss79 MuiTabs-indicator"></span></button><button class="MuiButtonBase-root MuiTab-root MuiTab-textColorInherit" tabindex="-1" type="button" role="tab" aria-selected="false"><span class="MuiTab-wrapper">Find a job</span></button></div>
                </div>
              </div>
            </div>
            <div class="MuiGrid-root jss70 MuiGrid-container MuiGrid-direction-xs-column">
              <div class="jss68 jss71">
                <div class="MuiGrid-root MuiGrid-container MuiGrid-item MuiGrid-grid-xs-12">
                  <div class="MuiFormControl-root MuiTextField-root jss81 jss87 jss88" tabindex="-1"><label class="MuiFormLabel-root MuiInputLabel-root MuiInputLabel-formControl MuiInputLabel-animated" data-shrink="false" for="zipCode" id="zipCode-label">ZIP code</label>
                    <div class="MuiInputBase-root MuiInput-root MuiInputBase-formControl MuiInput-formControl MuiInputBase-adornedEnd">
                      <input type="number" aria-invalid="false" autoComplete="off" id="zipCode" name="zipCode" value="" class="MuiInputBase-input MuiInput-input MuiInputBase-inputAdornedEnd" />
                      <div class="MuiInputAdornment-root MuiInputAdornment-positionEnd"><svg class="MuiSvgIcon-root jss92" focusable="false" viewBox="0 0 24 24" aria-hidden="true">
                          <path fill="#213f5f" fill-rule="evenodd" d="M11.24 20.25a.81.81 0 0 0 .75.45.91.91 0 0 0 .77-.4l3.83-6.62.14-.25c.17-.31.45-.81.74-1.45a7 7 0 0 0 .74-2.61 6.22 6.22 0 1 0-12.44 0A6.77 6.77 0 0 0 6.52 12a13.35 13.35 0 0 0 .86 1.6l3.83 6.64ZM16 13.39l-3.68 6.39-.43.76-.43-.77-3.65-6.46a14.78 14.78 0 0 1-.89-1.71 6.2 6.2 0 0 1-.62-2.22 5.69 5.69 0 0 1 5.7-5.7 5.57 5.57 0 0 1 5.62 5.7 6.23 6.23 0 0 1-.62 2.26 17.53 17.53 0 0 1-1 1.75Z">
                          </path>
                          <path fill="#213f5f" d="m11.25 20.26-.25.14Zm0 0 .27-.13Zm1.53.06.26.16Zm3.83-6.62.26.15Zm.14-.25-.26-.15Zm0 0-.26-.16Zm0 0 .26.15Zm0 0-.27-.15Zm.73-1.45-.27-.13Zm-11 0 .27-.12Zm.86 1.6.25-.16Zm0 0 .26-.15Zm0 0-.26.15Zm3.83 6.64.26-.15Zm1.12-.46-.26-.15ZM16 13.39l-.26-.16Zm-4.11 7.15-.26.14.26.46.26-.46Zm-.43-.77.26-.14Zm-3.65-6.46.26-.15Zm-.89-1.71-.28.12Zm10.7-2.22ZM17 11.64l-.27-.12Zm-5.44 8.49-.54.26Zm.48.28a.51.51 0 0 1-.48-.28l-.56.27a1.12 1.12 0 0 0 1 .6Zm.51-.25a.61.61 0 0 1-.51.25V21a1.22 1.22 0 0 0 1-.54Zm3.83-6.62-3.83 6.62.52.3 3.83-6.62Zm.14-.25c-.06.11-.12.2-.15.27l.53.27.14-.25Zm0 0 .52.29Zm0 0 .52.31Zm0 0 .54.27Zm.74-1.44c-.29.63-.56 1.12-.73 1.43l.52.29c.17-.31.46-.82.75-1.47Zm.71-2.48a6.78 6.78 0 0 1-.71 2.48l.54.25a7.28 7.28 0 0 0 .77-2.73ZM12 3.46a6 6 0 0 1 5.92 5.92h.6A6.56 6.56 0 0 0 12 2.86ZM6.08 9.38A6 6 0 0 1 12 3.46v-.6a6.56 6.56 0 0 0-6.52 6.52Zm.71 2.47a6.68 6.68 0 0 1-.71-2.47h-.6a7.18 7.18 0 0 0 .77 2.72Zm.84 1.56a13.41 13.41 0 0 1-.84-1.56l-.54.25a14.21 14.21 0 0 0 .88 1.64Zm0 0-.5.33Zm0 0-.52.3Zm3.83 6.64-3.8-6.6-.52.3L11 20.39Zm0 0-.52.3Zm1.11-.17 3.68-6.39-.52-.3-3.68 6.39Zm-.43.75.43-.75-.52-.3-.43.76Zm-1-.76.44.76.52-.29-.43-.76Zm-3.59-6.41 3.67 6.46.53-.29-3.68-6.47Zm-.91-1.74a16.06 16.06 0 0 0 .92 1.75l.51-.32a13.37 13.37 0 0 1-.88-1.68ZM6 9.38a6.45 6.45 0 0 0 .64 2.34l.55-.25a5.83 5.83 0 0 1-.59-2.09Zm6-6a6 6 0 0 0-6 6h.6A5.39 5.39 0 0 1 12 4Zm5.92 6a5.87 5.87 0 0 0-5.92-6V4a5.26 5.26 0 0 1 5.32 5.39Zm-.69 2.38a6.59 6.59 0 0 0 .69-2.39h-.6a6 6 0 0 1-.63 2.14Zm-.95 1.78a16.09 16.09 0 0 0 .95-1.78l-.54-.25a15.52 15.52 0 0 1-.92 1.71Zm-4.36-1.64a2.29 2.29 0 1 0-2.29-2.29 2.28 2.28 0 0 0 2.29 2.29Z">
                          </path>
                        </svg></div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="jss69 jss72"><button class="MuiButtonBase-root MuiButton-root MuiButton-contained MuiButton-containedPrimary MuiButton-containedSizeLarge MuiButton-sizeLarge" tabindex="0" type="button"><span class="MuiButton-label">Search</span></button></div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<div class="jss93">
  <div class="jss95 jss97"><svg width="1440" height="85" viewBox="0 0 1440 85" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
      <path d="M7.89135e-06 40.2672C7.89135e-06 40.2672 222.113 -19.0729 720 40.2671C1293.5 108.619 1440 0.000606533 1440 0.000606533L1440 179.884L1.57259e-05 179.884L7.89135e-06 40.2672Z" class="jss96 jss98"></path>
    </svg></div>
</div>
<div class="jss94">
  <div class="jss99 triageTabs" data-testid="vertical-selection">
    <div tabindex="0" role="button" class="jss100 triageTabs" data-testid="CHILDCARE"><svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M14.8595 17.125C13.6225 17.2162 8.68222 26.594 8.55161 26.5953C8.5133 26.5953 8.4773 26.5868 8.43945 26.5832C9.18853 34.2959 15.8799 40.3515 23.9998 40.3515C32.1196 40.3515 38.7482 34.3556 39.5513 26.6959C38.7639 26.5495 38.019 26.3515 37.3142 26.1139C29.2488 9.42983 15.5624 23.6517 14.8595 17.125Z" fill="#F3DEDC"></path>
        <path d="M24.2543 35.3862C22.3998 35.3862 20.7203 34.5079 19.7986 33.7512C19.3181 33.3569 19.2577 32.6577 19.6629 32.1898C20.0677 31.7241 20.7844 31.664 21.264 32.0551C21.5713 32.3039 24.3203 34.3983 26.6617 32.1215C27.1066 31.6887 27.827 31.6887 28.2715 32.1215C28.716 32.5544 28.7164 33.2554 28.2715 33.6879C26.9838 34.9408 25.5752 35.3862 24.2543 35.3862Z" fill="#E84E3A"></path>
        <path d="M39.6009 24.203C39.1052 16.2469 32.2989 9.92188 24.0005 9.92188C15.702 9.92188 8.91924 16.2258 8.40324 24.1626C8.38247 24.4837 8.36816 24.8066 8.36816 25.1326C8.36816 25.6189 8.39401 26.0994 8.44016 26.5745C8.47755 26.5781 8.51355 26.5862 8.55232 26.5867C8.68247 26.5853 9.48232 26.5871 10.7192 26.4959C14.6917 26.2036 23.184 24.9521 28.5891 19.5619C29.9502 21.4283 32.7997 24.5847 37.3149 26.1053C38.0202 26.3428 38.7651 26.5409 39.552 26.6872C39.6055 26.1758 39.6332 25.6571 39.6332 25.1326C39.6332 24.82 39.6199 24.5106 39.6009 24.203Z" fill="#E84E3A"></path>
        <path d="M24.6477 11.3697C24.5129 11.3697 24.3749 11.3459 24.2416 11.2961C23.6591 11.0774 23.3637 10.4474 23.5834 9.8775C23.6296 9.7576 24.7502 6.94287 27.8729 6.82117C28.4919 6.79737 29.0314 7.27248 29.0568 7.88366C29.0822 8.49528 28.5929 9.01081 27.9648 9.03551C26.3665 9.09748 25.7383 10.6014 25.7116 10.6656C25.5343 11.1012 25.1037 11.3697 24.6477 11.3697Z" fill="#E84E3A"></path>
        <path d="M23.6884 11.1931C23.2223 11.1931 22.7843 10.9125 22.6172 10.4603C22.0094 8.8167 20.598 8.57061 20.5389 8.56118C19.9246 8.46149 19.4977 7.89971 19.5909 7.30111C19.6837 6.70251 20.2514 6.29431 20.8615 6.36795C20.9764 6.38322 23.6737 6.77346 24.7597 9.70989C24.9734 10.2856 24.6655 10.9201 24.0738 11.1271C23.9464 11.172 23.8168 11.1931 23.6884 11.1931Z" fill="#E84E3A"></path>
        <path d="M15.9966 30.4023C16.6251 30.4023 17.1347 29.9065 17.1347 29.2949C17.1347 28.6833 16.6251 28.1875 15.9966 28.1875C15.368 28.1875 14.8584 28.6833 14.8584 29.2949C14.8584 29.9065 15.368 30.4023 15.9966 30.4023Z" fill="#E84E3A"></path>
        <path d="M32.0034 30.4023C32.632 30.4023 33.1415 29.9065 33.1415 29.2949C33.1415 28.6833 32.632 28.1875 32.0034 28.1875C31.3748 28.1875 30.8652 28.6833 30.8652 29.2949C30.8652 29.9065 31.3748 30.4023 32.0034 30.4023Z" fill="#E84E3A"></path>
      </svg>
      <p class="MuiTypography-root jss101 triageTabs MuiTypography-body2">Live Jobs</p>
    </div>
    <div tabindex="1" role="button" class="jss100 triageTabs" data-testid="SENIRCARE"><svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M17.7022 19.4941L17.7258 19.4739C18.9798 18.1784 21.0073 17.9354 22.5456 18.8955L27.9202 22.2455C28.7671 22.7709 29.903 22.6106 30.5602 21.8728C30.9414 21.4449 31.1122 20.8992 31.0416 20.3366C30.9714 19.7739 30.6705 19.284 30.1924 18.9557C30.1924 18.9557 19.871 12.213 19.6019 12.0361C18.191 11.1056 16.4584 10.6094 14.6579 10.6094C14.4119 10.6094 14.165 10.6188 13.9167 10.6372C12.3193 10.7603 10.823 11.2677 9.59021 12.1061C6.70329 14.0672 5.22314 17.8999 6.06821 21.2203C6.50021 22.916 7.54006 24.5263 8.76544 26.0374C9.3516 26.76 10.4561 26.8188 11.1119 26.1555L17.7022 19.4941Z" fill="#F3DEDC"></path>
        <path d="M9.9947 27.7694C9.94993 27.7694 9.90516 27.768 9.85993 27.7662C9.06378 27.7285 8.32347 27.3567 7.8287 26.7469C6.25763 24.8091 5.33039 23.1391 4.90993 21.4901C3.94993 17.7198 5.63132 13.3692 8.90686 11.1441C10.3118 10.1885 12.0116 9.60921 13.8227 9.46955C16.1932 9.29172 18.4422 9.85799 20.2718 11.0646C20.5395 11.2402 30.8581 17.9816 30.8581 17.9816C31.6372 18.5155 32.1153 19.2933 32.227 20.1865C32.3382 21.0792 32.0669 21.9446 31.4627 22.6231C30.4201 23.7929 28.6219 24.0466 27.2793 23.2145L21.9024 19.8632C20.8455 19.2035 19.4553 19.3705 18.5945 20.2601L18.5272 20.3248L11.9719 26.9507C11.4532 27.4752 10.7387 27.7694 9.9947 27.7694ZM14.6581 11.7607C14.4435 11.7607 14.2247 11.7688 14.0082 11.7849C12.6236 11.8914 11.3313 12.3283 10.2739 13.0477C7.77701 14.7438 6.49578 18.0593 7.22686 20.931C7.56239 22.2481 8.34932 23.6389 9.70255 25.3081C9.7944 25.4217 9.91393 25.4432 9.9767 25.4464C10.0482 25.4491 10.1585 25.4347 10.2522 25.3399L16.8993 18.6246C18.5502 16.9604 21.1861 16.6568 23.1906 17.9079L28.5642 21.2575C28.909 21.4712 29.3904 21.403 29.6586 21.1017C29.8178 20.9225 29.8865 20.7029 29.8575 20.4658C29.8279 20.2296 29.7061 20.032 29.5053 19.8941C29.5053 19.8941 19.2038 13.1645 18.9342 12.9875C17.7329 12.1954 16.2149 11.7598 14.6581 11.7598V11.7607Z" fill="#F3DEDC"></path>
        <path d="M38.908 12.1055C37.6752 11.2671 36.1789 10.7597 34.5787 10.6366C32.5217 10.4835 30.5001 10.9788 28.8949 12.0355C28.6374 12.2057 27.3635 12.882 26.5937 13.7891L31.5326 17.0803C32.5512 17.779 33.2218 18.8653 33.3714 20.0594C33.5209 21.2521 33.1429 22.4578 32.3343 23.3672C31.5035 24.3003 30.2911 24.8356 29.0071 24.8356C28.168 24.8356 27.3543 24.6043 26.6537 24.1679L21.2791 20.8178C20.6818 20.4447 19.8995 20.5435 19.42 21.0509L12.3935 28.1533C11.8807 28.6715 11.8761 29.4906 12.3829 30.0142L12.4083 30.0407C12.9538 30.6047 13.8746 30.6065 14.4229 30.0452L19.2857 25.0673C19.5012 24.8459 19.792 24.7198 20.1054 24.7121C20.116 24.7121 20.1257 24.7121 20.1363 24.7121C20.4381 24.7121 20.7243 24.823 20.9444 25.0269C21.172 25.2371 21.3017 25.5204 21.3095 25.8253C21.3174 26.1303 21.2029 26.4199 20.9864 26.6408L15.9806 31.7651C15.4927 32.2649 15.5251 33.058 16.0526 33.5178L16.0715 33.5344C16.5829 33.9804 17.3671 33.944 17.8327 33.4532L22.6411 28.3801C22.8538 28.1551 23.1437 28.0249 23.4566 28.0123C23.4811 28.0114 23.5046 28.0114 23.5286 28.0118C23.7067 28.015 23.8854 28.0559 24.0427 28.138C24.4729 28.3635 24.7106 28.7887 24.6732 29.2486C24.6515 29.5167 24.52 29.7659 24.3326 29.9635L19.6932 34.8587C19.2275 35.3505 19.3046 36.1269 19.8589 36.5221L19.8829 36.5391C20.3583 36.8782 21.0206 36.8126 21.4161 36.3873L26.2041 31.2375C26.4132 31.0111 26.6998 30.8778 27.0118 30.8621C27.0326 30.8607 27.0534 30.8603 27.0737 30.8603C27.3649 30.8603 27.6427 30.964 27.8611 31.1566C28.1306 31.3937 28.2718 31.7328 28.2446 32.0934C28.2247 32.3579 28.0978 32.6044 27.9151 32.8011L23.2004 37.8719C22.9337 38.1589 23.074 38.6187 23.4584 38.718L23.4663 38.7198C23.9546 38.8451 24.5394 38.846 25.0304 38.7198C25.8247 38.5159 26.6564 37.9249 27.46 37.3546C27.64 37.2266 30.1097 35.4618 31.2054 34.5677C33.1327 32.9884 35.0011 31.2262 36.9151 29.1843L37.1038 28.9827C39.2587 26.6804 41.7012 24.0704 42.4291 21.2193C43.2737 17.8989 41.7926 14.0661 38.9071 12.106L38.908 12.1055Z" fill="#E84E3A"></path>
        <path d="M39.5922 11.1438C38.1859 10.1873 36.4851 9.60798 34.6704 9.46877C32.3405 9.29319 30.0522 9.86126 28.2259 11.0643C28.1931 11.0854 28.1419 11.1159 28.0764 11.155C27.5475 11.4712 26.4471 12.1281 25.6741 13.0402L24.8433 14.02L30.8461 18.0194C31.5896 18.5295 32.0788 19.3208 32.1878 20.1897C32.2962 21.0578 32.0216 21.9353 31.4336 22.5967C30.8295 23.2753 29.9456 23.6646 29.0087 23.6646C28.399 23.6646 27.8078 23.4971 27.2987 23.1801L21.925 19.8309C20.8395 19.1524 19.4165 19.3298 18.5608 20.2355L11.5344 27.3379C10.579 28.3034 10.5707 29.8244 11.5168 30.8025L11.545 30.8317C12.0301 31.3324 12.7058 31.6166 13.423 31.6166C13.6764 31.6166 13.915 31.4985 14.0867 31.3176L19.3127 25.8107C19.4807 25.6342 19.7645 25.6234 19.9455 25.7864C20.1268 25.9494 20.1384 26.2252 19.9704 26.4016L14.7656 31.8861C14.5584 32.1043 14.4324 32.3913 14.4444 32.693C14.4711 33.3424 14.7596 33.9387 15.2761 34.3892C15.283 34.395 15.2899 34.4008 15.2968 34.4071C16.1848 35.1642 17.5501 35.0403 18.3508 34.1965L23.3876 28.8886C23.5556 28.7116 23.8395 28.7018 24.0204 28.8639C24.2018 29.0273 24.2133 29.3026 24.0458 29.4795L23.7938 29.7454C23.5727 29.9784 23.3511 30.2115 23.1301 30.445L22.1922 31.4334L21.1178 32.5655L20.0442 33.6967C19.5536 34.2136 19.0136 34.7107 18.5608 35.2594C18.4261 35.4225 18.3005 35.6007 18.2558 35.8055C18.1173 36.4396 18.6975 37.088 19.1608 37.4545L19.1788 37.467C20.0211 38.0616 21.187 37.9493 21.8931 37.2057L27.0075 31.8165C27.1755 31.64 27.4593 31.6292 27.6402 31.7922C27.8216 31.9552 27.8331 32.231 27.6651 32.4074C27.2244 32.8614 26.7836 33.3154 26.3433 33.769C25.5195 34.6177 24.6956 35.4665 23.8718 36.3152C23.5722 36.6237 23.2722 36.9327 22.9727 37.2412C22.4881 37.7401 21.6135 38.4244 22.1096 39.1946C22.3302 39.5372 22.7742 39.7339 23.1628 39.8341C23.5085 39.923 23.8796 39.9674 24.2502 39.9674C24.6208 39.9674 24.9915 39.9234 25.3367 39.8345C26.347 39.575 27.2687 38.9207 28.1655 38.2843C28.1913 38.2659 30.8124 36.3969 31.9759 35.4476C33.9407 33.8373 35.8455 32.0419 37.7987 29.9582L37.9879 29.7566C40.2379 27.3528 42.7884 24.6278 43.5892 21.4902C44.5482 17.7212 42.8673 13.3711 39.5927 11.146L39.5922 11.1438ZM41.2718 20.9293C40.6164 23.4966 38.2824 25.9903 36.223 28.1903L36.0347 28.3915C34.1525 30.3988 32.3216 32.125 30.4395 33.6675C29.3359 34.5679 26.7827 36.3879 26.7531 36.409C26.2482 36.7674 25.7308 37.1347 25.267 37.3709L28.8015 33.5692C29.1725 33.1695 29.3982 32.6715 29.4356 32.1676C29.4896 31.4514 29.2076 30.7648 28.6621 30.2847C28.225 29.9003 27.661 29.6883 27.0739 29.6883C27.0259 29.6883 26.9788 29.6897 26.9521 29.6919C26.4568 29.7162 25.9925 29.8877 25.6122 30.1805C25.7539 29.9106 25.8402 29.6205 25.8638 29.3282C25.9381 28.4004 25.4571 27.5486 24.6088 27.104C24.2918 26.9383 23.9267 26.8467 23.5436 26.839C23.4956 26.839 23.449 26.839 23.4079 26.8408C22.7761 26.866 22.1918 27.1296 21.7639 27.5818L16.9561 32.6549C16.9325 32.68 16.8942 32.6814 16.8495 32.6427C16.8444 32.6383 16.8296 32.6252 16.8287 32.5992C16.8278 32.5727 16.8411 32.5592 16.8462 32.5543L21.8525 27.43C22.2878 26.9841 22.519 26.3998 22.5033 25.7855C22.4793 24.8636 21.9028 24.0364 20.9401 23.6664C20.6913 23.5707 20.4222 23.538 20.155 23.5402L20.0765 23.5411C19.4438 23.5568 18.8553 23.8114 18.4219 24.2574L13.5591 29.2352C13.5121 29.2837 13.4567 29.2941 13.4188 29.2941C13.3805 29.2941 13.3256 29.2837 13.2762 29.233L13.2527 29.2087C13.1821 29.1356 13.1825 29.0215 13.2541 28.9492L20.2985 21.8275C20.3853 21.7359 20.527 21.7188 20.6355 21.7862L26.0105 25.1366C26.9045 25.6935 27.9407 25.9876 29.0078 25.9876C30.6379 25.9876 32.1795 25.3059 33.2373 24.1173C34.2661 22.9609 34.747 21.4269 34.5568 19.9091C34.3662 18.3894 33.5147 17.009 32.2076 16.1122L28.5148 13.6518C28.8375 13.4259 29.1402 13.245 29.3253 13.1345C29.4324 13.0703 29.5155 13.0204 29.5648 12.9872C30.9453 12.0783 32.6922 11.6526 34.4858 11.7842C35.8741 11.8906 37.1668 12.3275 38.2251 13.0474C40.7207 14.7435 42.0019 18.0585 41.2718 20.9293Z" fill="#E84E3A"></path>
      </svg>
      <p class="MuiTypography-root jss101 triageTabs MuiTypography-body2">Compaines</p>
    </div>
    <div tabindex="2" role="button" class="jss100 triageTabs" data-testid="HOUSEKEEP"><svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M37.9069 38.4682H12.2315C11.3896 38.4682 10.707 37.804 10.707 36.985V20.5097L25.0692 9.73438L39.4313 20.5097V36.985C39.4313 37.804 38.7487 38.4682 37.9069 38.4682Z" fill="#F3DEDC"></path>
        <path d="M40.7413 22.1681C40.3998 22.1681 40.0555 22.0603 39.7665 21.8384L26.2333 11.4332C25.5507 10.9082 24.587 10.9082 23.9039 11.4332L10.3707 21.8384C9.68854 22.3625 8.69946 22.2498 8.16039 21.5861C7.62131 20.9228 7.73762 19.96 8.41931 19.4355L24.0927 7.38441C24.6645 6.94478 25.4722 6.94478 26.0441 7.38441L41.7175 19.4355C42.3992 19.96 42.5155 20.9228 41.9764 21.5861C41.6658 21.9687 41.2061 22.1681 40.7413 22.1681Z" fill="#E84E3A"></path>
        <path d="M17.5933 23.3594H21.2672C22.457 23.3594 23.423 24.2993 23.423 25.457V38.4655H15.4375V25.457C15.4375 24.2993 16.4035 23.3594 17.5933 23.3594Z" fill="#E84E3A"></path>
        <path d="M29.5494 23.3594H33.2232C34.4131 23.3594 35.3791 24.2993 35.3791 25.457V30.9122H27.3936V25.457C27.3936 24.2993 28.3596 23.3594 29.5494 23.3594Z" fill="#E84E3A"></path>
        <path d="M35.4976 30.2969H27.2749C26.7579 30.2969 26.3389 30.7046 26.3389 31.2076C26.3389 31.7105 26.7579 32.1183 27.2749 32.1183H35.4976C36.0146 32.1183 36.4336 31.7105 36.4336 31.2076C36.4336 30.7046 36.0146 30.2969 35.4976 30.2969Z" fill="#E84E3A"></path>
        <path d="M8.60536 28.033C8.65706 27.8848 8.87213 27.8848 8.92382 28.033C9.37059 29.3196 10.4091 30.33 11.7314 30.7647C11.8837 30.815 11.8837 31.0242 11.7314 31.0745C10.4091 31.5092 9.37059 32.5196 8.92382 33.8062C8.87213 33.9544 8.65706 33.9544 8.60536 33.8062C8.15859 32.5196 7.12013 31.5092 5.79782 31.0745C5.64552 31.0242 5.64552 30.815 5.79782 30.7647C7.12013 30.33 8.15859 29.3196 8.60536 28.033Z" fill="#E84E3A"></path>
        <path d="M36.2743 5.65021C36.326 5.50201 36.5411 5.50201 36.5928 5.65021C37.0395 6.93678 38.078 7.94717 39.4003 8.38186C39.5526 8.43216 39.5526 8.64142 39.4003 8.69172C38.078 9.12641 37.0395 10.1368 36.5928 11.4234C36.5411 11.5716 36.326 11.5716 36.2743 11.4234C35.8275 10.1368 34.7891 9.12641 33.4668 8.69172C33.3145 8.64142 33.3145 8.43216 33.4668 8.38186C34.7891 7.94717 35.8275 6.93678 36.2743 5.65021Z" fill="#E84E3A"></path>
      </svg>
      <p class="MuiTypography-root jss101 triageTabs MuiTypography-body2">Candidates</p>
    </div>
    <!-- <div tabindex="3" role="button" class="jss100 triageTabs" data-testid="PETCAREXX"><svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M38.4118 17.7742C38.1999 17.732 37.9899 17.7042 37.7822 17.6894C37.2819 17.6539 36.8864 17.2767 36.8652 16.789C36.8642 16.7652 36.8629 16.741 36.8619 16.7172C36.7553 14.6694 36.0086 12.5162 34.8136 10.8097C33.2993 8.64701 31.2307 7.46148 29.1339 7.56926C28.1647 7.61731 27.2989 7.91908 26.5438 8.4126C25.4541 9.12482 24.0427 9.12482 22.9535 8.4126C22.1984 7.91908 21.333 7.61731 20.3633 7.56926C18.2689 7.46732 16.1984 8.64701 14.6841 10.8093C13.4892 12.5162 12.7424 14.669 12.6358 16.7167C12.6344 16.741 12.6335 16.7656 12.6321 16.7899C12.6109 17.2776 12.2158 17.6548 11.7155 17.6898C11.5078 17.7042 11.2978 17.732 11.0859 17.7742C9.14886 18.1604 7.54316 19.6823 6.68009 21.9505C6.00578 23.7235 5.84009 25.7909 6.22547 27.6231C6.62193 29.5074 7.55147 31.2053 8.84332 32.4048C9.46732 32.9841 10.1587 33.4291 10.8842 33.7309C12.1105 34.2405 13.0438 35.2141 13.4984 36.4342C14.2853 38.5444 16.1199 40.2086 18.6173 40.8723C19.2944 41.0524 19.9899 41.1409 20.6813 41.1409C21.9709 41.1409 23.2461 40.8328 24.3575 40.2329L24.3612 40.2306C24.5906 40.1071 24.8707 40.1022 25.0992 40.2266C26.8498 41.1786 29.0292 41.4013 31.0816 40.8108C31.473 40.699 31.8598 40.558 32.2313 40.3923C34.0433 39.5853 35.3721 38.1312 36.0085 36.4005C36.4456 35.2119 37.3539 34.2446 38.5521 33.7596C40.8039 32.8484 42.6482 30.5865 43.2722 27.6231C44.1205 23.5919 42.3335 18.5556 38.4118 17.7742Z" fill="#F3DEDC"></path>
        <path d="M40.3501 27.0375C39.7801 29.7462 37.7516 31.63 35.8192 31.2447C33.8872 30.8599 32.7832 28.3519 33.3532 25.6431C33.9232 22.9344 35.8819 20.2296 37.8139 20.6149C39.7459 20.9998 40.9201 24.3287 40.3501 27.0375Z" fill="#E84E3A"></path>
        <path d="M9.14922 27.0375C9.71922 29.7462 11.7477 31.63 13.6801 31.2447C15.6121 30.8599 16.7161 28.3519 16.1461 25.6431C15.5761 22.9344 13.6174 20.2296 11.6854 20.6149C9.75338 20.9998 8.57922 24.3287 9.14922 27.0375Z" fill="#E84E3A"></path>
        <path d="M33.8836 16.8669C34.0479 20.0175 32.3961 22.6594 30.1941 22.7681C27.9921 22.8767 26.0739 20.4109 25.9101 17.2603C25.7457 14.1096 27.0851 10.58 29.2871 10.4713C31.4891 10.3626 33.7197 13.7163 33.8841 16.8664L33.8836 16.8669Z" fill="#E84E3A"></path>
        <path d="M15.6167 16.8669C15.4524 20.0175 17.1043 22.6594 19.3063 22.7681C21.5083 22.8767 23.4264 20.4109 23.5903 17.2603C23.7546 14.1096 22.4152 10.58 20.2132 10.4713C18.0112 10.3626 15.7806 13.7163 15.6163 16.8664L15.6167 16.8669Z" fill="#E84E3A"></path>
        <path d="M19.4046 38.075C20.5616 38.3826 21.8406 38.2749 22.9141 37.696C23.0562 37.6192 23.1915 37.5308 23.3198 37.4338C24.1755 36.7885 25.2961 36.8401 26.1707 37.4567C27.3402 38.2812 28.8726 38.4226 30.2396 38.0297C30.4949 37.9565 30.7459 37.8653 30.991 37.7558C32.5575 37.0584 33.6776 35.4709 33.4113 33.486C33.1159 31.2829 31.7595 29.325 30.4422 27.7699C29.9516 27.1906 29.2381 26.4968 28.4807 25.8133C26.3332 23.8747 23.1689 23.8747 21.0209 25.8133C20.2635 26.4968 19.5495 27.1906 19.0593 27.7699C17.7426 29.325 16.3856 31.2825 16.0902 33.486C15.7612 35.942 17.4416 37.5532 19.4046 38.075Z" fill="#E84E3A"></path>
      </svg>
      <p class="MuiTypography-root jss101 triageTabs MuiTypography-body2">Pet care</p>
    </div> -->
    <div tabindex="4" role="button" class="jss100 triageTabs" data-testid="TUTORINGX"><svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M36.3466 39.1657H13.5277C12.3997 39.1657 11.4854 38.2514 11.4854 37.1234V8.99543C11.4854 7.86743 12.3997 6.95312 13.5277 6.95312H32.999C35.1041 9.0582 36.2843 10.2384 38.3889 12.343V37.1234C38.3889 38.2514 37.4746 39.1657 36.3466 39.1657Z" fill="#F3DEDC"></path>
        <path d="M32.9765 6.95359L32.9405 10.9639C32.9349 11.5542 33.3923 12.0457 33.9817 12.0836L38.388 12.3647L32.9765 6.95312V6.95359Z" fill="#E84E3A"></path>
        <path d="M34.4585 16.3407H15.4155C15.1685 16.3407 14.9678 16.1404 14.9678 15.893C14.9678 15.6456 15.1681 15.4453 15.4155 15.4453H34.4585C34.7055 15.4453 34.9062 15.6456 34.9062 15.893C34.9062 16.1404 34.7059 16.3407 34.4585 16.3407Z" fill="#E84E3A"></path>
        <path d="M34.4585 20.3251H15.4155C15.1685 20.3251 14.9678 20.1248 14.9678 19.8774C14.9678 19.63 15.1681 19.4297 15.4155 19.4297H34.4585C34.7055 19.4297 34.9062 19.63 34.9062 19.8774C34.9062 20.1248 34.7059 20.3251 34.4585 20.3251Z" fill="#E84E3A"></path>
        <path d="M34.4585 24.661H15.4155C15.1685 24.661 14.9678 24.4607 14.9678 24.2133C14.9678 23.9659 15.1681 23.7656 15.4155 23.7656H34.4585C34.7055 23.7656 34.9062 23.9659 34.9062 24.2133C34.9062 24.4607 34.7059 24.661 34.4585 24.661Z" fill="#E84E3A"></path>
        <path d="M34.4585 28.9972H15.4155C15.1685 28.9972 14.9678 28.7969 14.9678 28.5495C14.9678 28.3021 15.1681 28.1018 15.4155 28.1018H34.4585C34.7055 28.1018 34.9062 28.3021 34.9062 28.5495C34.9062 28.7969 34.7059 28.9972 34.4585 28.9972Z" fill="#E84E3A"></path>
        <path d="M30.9859 33.3329H15.4155C15.1685 33.3329 14.9678 33.1326 14.9678 32.8852C14.9678 32.6378 15.1681 32.4375 15.4155 32.4375H30.9859C31.2329 32.4375 31.4336 32.6378 31.4336 32.8852C31.4336 33.1326 31.2333 33.3329 30.9859 33.3329Z" fill="#E84E3A"></path>
        <path d="M24.788 40.8906C23.7472 41.1191 22.7881 41.8017 22.2412 42.7742L23.9835 43.7134C24.6574 44.0766 25.4411 43.4651 25.2528 42.7234L24.788 40.8906Z" fill="#E84E3A"></path>
        <path d="M24.7875 40.8828L23.8446 37.1665L11.1135 20.8438L6.21289 24.6662L18.944 40.989L22.2407 42.7659C22.7877 41.7939 23.7467 41.1113 24.7875 40.8828Z" fill="#EB998A"></path>
        <path d="M6.4689 19.9469C5.11567 21.0024 4.87428 22.9552 5.92982 24.3084L6.82521 25.4563C7.84197 23.3618 9.46936 21.9592 11.7258 21.6338L10.8304 20.4855C9.7749 19.1323 7.82213 18.8909 6.4689 19.9464V19.9469Z" fill="#EB998A"></path>
        <path d="M23.8446 37.1665L11.1135 20.8438L6.21289 24.6662L18.944 40.989C18.944 40.989 19.5735 37.6839 23.8446 37.1665Z" fill="#E84E3A"></path>
      </svg>
      <p class="MuiTypography-root jss101 triageTabs MuiTypography-body2">Total New Jobs</p>
    </div>
  </div>
</div>
<div>
  <div class="jss102">
    <div class="jss104">
      <div class="jss95 jss109"><svg width="1440" height="85" viewBox="0 0 1440 85" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
          <path d="M7.89135e-06 40.2672C7.89135e-06 40.2672 222.113 -19.0729 720 40.2671C1293.5 108.619 1440 0.000606533 1440 0.000606533L1440 179.884L1.57259e-05 179.884L7.89135e-06 40.2672Z" class="jss96 jss110"></path>
        </svg></div>
    </div>
    <section class="jss103" data-testid="caregiver-reviews">
      <div>
        <h2 class="MuiTypography-root jss40 jss105 MuiTypography-body1">Access a network of background checked
          caregivers</h2>
        <p class="MuiTypography-root jss106 MuiTypography-body1">With an average 4.7 star rating, you’ll find a
          caregiver to rave about too.</p>
      </div>
      <div class="MuiBox-root jss113 jss111"><span class="MuiSkeleton-root MuiSkeleton-rect jss112 MuiSkeleton-pulse"></span><span class="MuiSkeleton-root MuiSkeleton-rect jss112 MuiSkeleton-pulse"></span><span class="MuiSkeleton-root MuiSkeleton-rect jss112 MuiSkeleton-pulse"></span></div>
      <div class="jss107"><button class="MuiButtonBase-root MuiButton-root MuiButton-contained jss108 MuiButton-containedPrimary MuiButton-containedSizeLarge MuiButton-sizeLarge" tabindex="0" type="button"><span class="MuiButton-label">Job Title now</span></button><a class="MuiTypography-root MuiLink-root jss58 MuiLink-underlineNone MuiTypography-colorPrimary" href="#"><span class="MuiTypography-root jss32 MuiTypography-body1">Apply to jobs</span></a></div>
    </section>
  </div>
</div>
<section class="jss114 jss123 valueDrivers">
  <div class="jss115 jss124">
    <div class="logoBlock"><span class="jss120">Featured in</span><span class="jss116 jss125"></span><span class="jss116 jss125"></span><span class="jss116 jss125"></span></div>
  </div>
</section>
<div class="jss95 jss126"><svg width="1440" height="85" viewBox="0 0 1440 85" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
    <path d="M7.89135e-06 40.2672C7.89135e-06 40.2672 222.113 -19.0729 720 40.2671C1293.5 108.619 1440 0.000606533 1440 0.000606533L1440 179.884L1.57259e-05 179.884L7.89135e-06 40.2672Z" class="jss96 jss127"></path>
  </svg></div>
<div>
  <section class="jss128">
    <div class="jss129">
      <div class="jss95 jss132"><svg width="1440" height="85" viewBox="0 0 1440 85" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
          <path d="M7.89135e-06 40.2672C7.89135e-06 40.2672 222.113 -19.0729 720 40.2671C1293.5 108.619 1440 0.000606533 1440 0.000606533L1440 179.884L1.57259e-05 179.884L7.89135e-06 40.2672Z" class="jss96 jss133"></path>
        </svg></div>
    </div>
    <div class="jss130">
      <h2 class="MuiTypography-root jss40 jss131 MuiTypography-body1">Easily find a caregiver you can trust</h2>
      <div>
        <div class="jss134">
          <div class="jss135"><span class="MuiSkeleton-root MuiSkeleton-rect jss136 MuiSkeleton-pulse" style="width:235px;height:472px"></span><span class="MuiSkeleton-root MuiSkeleton-circle MuiSkeleton-pulse" style="width:50px;height:50px"></span>
            <h1>Browse nearby caregivers</h1>
            <p>Read reviews and set filters to find the right match.</p>
          </div>
          <div class="jss135"><span class="MuiSkeleton-root MuiSkeleton-rect jss136 MuiSkeleton-pulse" style="width:235px;height:472px"></span><span class="MuiSkeleton-root MuiSkeleton-circle MuiSkeleton-pulse" style="width:50px;height:50px"></span>
            <h1>Tell us what you need</h1>
            <p>Share your care needs and review profiles.</p>
          </div>
          <div class="jss135"><span class="MuiSkeleton-root MuiSkeleton-rect jss136 MuiSkeleton-pulse" style="width:235px;height:472px"></span><span class="MuiSkeleton-root MuiSkeleton-circle MuiSkeleton-pulse" style="width:50px;height:50px"></span>
            <h1>Choose your caregiver</h1>
            <p>Start a conversation and hire the caregiver that’s right for you.</p>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
<div class="jss95 jss137"><svg width="1440" height="85" viewBox="0 0 1440 85" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
    <path d="M7.89135e-06 40.2672C7.89135e-06 40.2672 222.113 -19.0729 720 40.2671C1293.5 108.619 1440 0.000606533 1440 0.000606533L1440 179.884L1.57259e-05 179.884L7.89135e-06 40.2672Z" class="jss96 jss138"></path>
  </svg></div>
<div class="jss139">
  <div class="jss140">
    <h2 class="MuiTypography-root jss40 jss141 MuiTypography-body1">Safety is a top priority</h2>
    <p class="MuiTypography-root jss142 MuiTypography-body2">All caregivers complete a background check before
      interacting with families. Additional safety tools available to premium members. Visit our<!-- --> <a class="MuiTypography-root MuiLink-root jss56 MuiLink-underlineNone MuiTypography-colorPrimary" target="_blank" href="about/safety/index.html"><span class="MuiTypography-root MuiTypography-body2">trust
          and safety center</span></a> <!-- -->to learn more.</p>
    <div class="jss143">
      <div role="button" class="jss146">
        <div class="jss147"><svg width="77" height="77" viewBox="0 0 77 77" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clip-path="url(#clip0_1425_28144)">
              <path d="M1.89798e-06 44.7957C9.89347e-07 24.0086 17.0459 1.99866 42.0266 1.38747C67.0073 0.776279 76.9557 22.7607 77 39.2931C77.0496 57.9401 65.5968 75.576 43.4063 75.6246C23.8055 75.6679 2.80661e-06 65.5829 1.89798e-06 44.7957Z" fill="#E6F3EE"></path>
            </g>
            <path d="M31.4817 26.9459C28.4555 28.027 23.3583 28.3874 21.1922 28.027C21.1922 31.0901 20.7595 38.7297 21.1927 44.7838C21.7342 52.3514 28 55 28 55L39.6046 61L49.8937 55.0541C52.7818 53.2523 58 49.8884 58 43.1466V27.471C56.3754 27.471 52.8179 27.8108 49.3521 26.9459C45.8864 26.0811 41.4097 22.6216 39.6046 21C38.3411 22.2613 35.1305 25.6425 31.4817 26.9459Z" stroke="#213F5F" stroke-width="2.5" stroke-linejoin="round"></path>
            <path d="M41.8874 37.9425L46.9274 38.7425C47.0286 38.7581 47.1235 38.8011 47.202 38.8669C47.2804 38.9326 47.3393 39.0186 47.3723 39.1155C47.4053 39.2124 47.4111 39.3165 47.3891 39.4165C47.367 39.5164 47.318 39.6085 47.2474 39.6825L43.6074 43.1425L44.4074 48.3425C44.4074 48.8225 43.9274 49.1425 43.6074 48.9825L39.2074 46.4625L34.6274 48.8225C34.1474 48.9825 33.6874 48.6625 33.8474 48.2025L34.7874 43.1425L31.1674 39.5225C30.8474 39.2025 31.0074 38.5825 31.4674 38.5825L36.5274 37.7825L38.7274 33.3825C38.7498 33.2745 38.8088 33.1774 38.8944 33.1077C38.98 33.038 39.087 33 39.1974 33C39.3078 33 39.4148 33.038 39.5004 33.1077C39.586 33.1774 39.645 33.2745 39.6674 33.3825L41.8874 37.9425Z" fill="#213F5F"></path>
            <defs>
              <clipPath id="clip0_1425_28144">
                <rect width="77" height="77" fill="white" transform="translate(0 77) rotate(-90)"></rect>
              </clipPath>
            </defs>
          </svg></div>
        <p class="MuiTypography-root jss148 MuiTypography-body2">CareCheck initial screening</p>
      </div>
      <div role="button" class="jss146">
        <div class="jss147"><svg width="77" height="77" viewBox="0 0 77 77" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clip-path="url(#clip0_1425_28177)">
              <path d="M1.89798e-06 44.7957C9.89347e-07 24.0086 17.0459 1.99866 42.0266 1.38747C67.0073 0.776279 76.9557 22.7607 77 39.2931C77.0496 57.9401 65.5968 75.576 43.4063 75.6246C23.8055 75.6679 2.80661e-06 65.5829 1.89798e-06 44.7957Z" fill="#E7F0FB"></path>
            </g>
            <path fill-rule="evenodd" clip-rule="evenodd" d="M39.9478 61.67H39.8296H39.3892C39.171 61.6475 38.9612 61.5738 38.7768 61.4551L27.2275 53.9347C25.16 52.5927 23.4621 50.7536 22.289 48.5858C21.116 46.418 20.5053 43.9907 20.5128 41.5259V28.0427C20.5134 27.8548 20.5529 27.6691 20.6287 27.4972C20.7045 27.3253 20.815 27.1708 20.9532 27.0436C21.0913 26.9197 21.2527 26.8245 21.4279 26.7636C21.6031 26.7028 21.7887 26.6774 21.9739 26.6891C33.362 27.57 38.7445 20.7801 38.9702 20.49C39.0896 20.3398 39.2394 20.2164 39.4098 20.128C39.5802 20.0395 39.7673 19.9881 39.959 19.9769C40.1506 19.9658 40.3425 19.9952 40.522 20.0632C40.7015 20.1313 40.8646 20.2365 41.0007 20.3719C43.2427 22.5432 45.9107 24.2257 48.8363 25.313C51.7618 26.4004 54.8811 26.869 57.9969 26.6891C58.1933 26.6652 58.3925 26.6847 58.5806 26.7461C58.7686 26.8076 58.9409 26.9095 59.0853 27.0447C59.2297 27.1798 59.3427 27.345 59.4164 27.5286C59.4901 27.7122 59.5226 27.9097 59.5118 28.1072L58.8966 37.8305C60.4376 38.9519 61.6305 40.4944 62.3266 42.2801C63.1166 44.3065 63.2238 46.5354 62.6319 48.6283C62.04 50.7211 60.7814 52.5637 59.0471 53.8762C57.3128 55.1888 55.1976 55.8996 53.0227 55.9007L52.9689 55.8899C51.8837 55.8899 50.8077 55.713 49.7827 55.3677L40.6999 61.4229C40.4803 61.5802 40.2179 61.6664 39.9478 61.67ZM56.8259 39.7102L56.8262 39.7104C58.1752 40.5436 59.2149 41.7948 59.7872 43.2734C60.3595 44.7522 60.4329 46.3775 59.9961 47.9019C59.5594 49.4262 58.6365 50.766 57.3679 51.7174C56.0993 52.6688 54.5546 53.1795 52.9689 53.1718C52.013 53.1761 51.0663 52.9887 50.1845 52.6213C50.171 52.6148 50.1573 52.6085 50.1434 52.6025C49.2377 52.1991 48.424 51.6149 47.7524 50.8857C47.0807 50.1565 46.5652 49.2976 46.2375 48.3619C45.9098 47.4261 45.7769 46.4333 45.847 45.4444C45.917 44.4554 46.1885 43.4912 46.6447 42.611C47.101 41.7307 47.7324 40.9531 48.5001 40.3258C49.2678 39.6985 50.1557 39.2347 51.1092 38.9631C52.0627 38.6914 53.0617 38.6176 54.0447 38.746C55.0278 38.8745 55.9743 39.2026 56.8259 39.7102ZM29.9671 52.4735L39.7222 58.8122L46.9848 53.9132C45.296 52.6607 44.0453 50.9074 43.4108 48.9028C42.7763 46.8983 42.7904 44.7446 43.451 42.7485C44.1116 40.7524 45.3851 39.0156 47.0901 37.7853C48.7952 36.555 50.8449 35.894 52.9475 35.8963C54.0678 35.8967 55.1798 36.0893 56.235 36.4657L56.6862 29.4501C54.4138 29.4461 52.152 29.139 49.9608 28.5369L29.9671 52.4735ZM23.2201 29.4716V41.5259C23.2182 43.3326 23.6227 45.1166 24.4038 46.7457C25.1849 48.3749 26.3225 49.8074 27.7324 50.9372L47.2212 27.613C44.6285 26.5647 42.2313 25.0864 40.1305 23.2404C37.8891 25.3821 35.2314 27.0404 32.3225 28.1123C29.4135 29.1842 26.3153 29.6469 23.2201 29.4716ZM51.5229 49.2802C51.6851 49.3466 51.8589 49.3803 52.0342 49.3794C52.2112 49.3793 52.3865 49.3431 52.549 49.2729C52.7116 49.2027 52.8581 49.1 52.9796 48.9711L57.3737 44.6737C57.5007 44.5489 57.6018 44.4002 57.6713 44.2363C57.7409 44.0723 57.7774 43.8963 57.7789 43.7182C57.7804 43.5401 57.7468 43.3635 57.6801 43.1984C57.6133 43.0333 57.5147 42.883 57.3898 42.756C57.2649 42.629 57.1163 42.5279 56.9524 42.4583C56.7884 42.3888 56.6124 42.3523 56.4343 42.3508C56.2562 42.3493 56.0796 42.3829 55.9145 42.4496C55.7494 42.5164 55.5991 42.615 55.4721 42.7399L52.0342 46.1241L51.3681 45.4795C51.1102 45.2287 50.7633 45.0907 50.4036 45.0957C50.044 45.1008 49.7011 45.2485 49.4503 45.5063C49.1996 45.7642 49.0616 46.1111 49.0666 46.4708C49.0716 46.8304 49.2193 47.1733 49.4772 47.4241L51.0887 48.9926C51.2131 49.1161 51.3607 49.2138 51.5229 49.2802Z" fill="#213F5F"></path>
            <defs>
              <clipPath id="clip0_1425_28177">
                <rect width="77" height="77" fill="white" transform="translate(0 77) rotate(-90)"></rect>
              </clipPath>
            </defs>
          </svg></div>
        <p class="MuiTypography-root jss148 MuiTypography-body2">Criminal records search</p>
      </div>
      <div role="button" class="jss146">
        <div class="jss147"><svg width="77" height="77" viewBox="0 0 77 77" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clip-path="url(#clip0_1425_28169)">
              <path d="M1.89798e-06 44.7957C9.89347e-07 24.0086 17.0459 1.99866 42.0266 1.38747C67.0073 0.776279 76.9557 22.7607 77 39.2931C77.0496 57.9401 65.5968 75.576 43.4063 75.6246C23.8055 75.6679 2.80661e-06 65.5829 1.89798e-06 44.7957Z" fill="#FFF3C2"></path>
            </g>
            <path fill-rule="evenodd" clip-rule="evenodd" d="M52.7389 54.2888H56.7764C56.9599 54.283 57.1428 54.3138 57.3143 54.3795C57.4858 54.4452 57.6424 54.5444 57.7751 54.6713C57.9052 54.8018 58.0064 54.9581 58.0723 55.1301C58.1381 55.3022 58.1672 55.4861 58.1576 55.6701C58.1635 55.8536 58.1326 56.0365 58.0669 56.208C58.0013 56.3795 57.9021 56.5361 57.7751 56.6688C57.499 56.9098 57.1427 57.0387 56.7764 57.0301H22.2239C21.8568 57.043 21.499 56.9136 21.2251 56.6688C21.0982 56.5361 20.999 56.3795 20.9333 56.208C20.8676 56.0365 20.8368 55.8536 20.8426 55.6701C20.833 55.4861 20.8621 55.3022 20.928 55.1301C20.9938 54.9581 21.0951 54.8018 21.2251 54.6713C21.3564 54.5424 21.5128 54.4418 21.6846 54.376C21.8565 54.3102 22.04 54.2805 22.2239 54.2888H25.7301L35.3776 23.4763C35.706 22.4743 36.3483 21.6047 37.2094 20.9961C38.0705 20.3876 39.1047 20.0725 40.1589 20.0976C41.2352 20.0676 42.2906 20.3986 43.1571 21.0378C44.0235 21.6771 44.6512 22.5878 44.9401 23.6251L47.5539 33.1663C47.9821 33.0913 48.4154 33.0487 48.8501 33.0388C51.0502 33.0434 53.1772 33.8289 54.8521 35.2554C56.5271 36.6819 57.6411 38.6568 57.9958 40.8281C58.3504 42.9994 57.9227 45.2261 56.7887 47.1114C55.6547 48.9968 53.8882 50.4182 51.8039 51.1226L52.7389 54.2888ZM52.5061 36.7291C51.423 36.0092 50.1506 35.6271 48.8501 35.6313C47.1177 35.6425 45.4594 36.3356 44.2344 37.5606C43.0094 38.7856 42.3163 40.4439 42.3051 42.1763C42.3009 43.4768 42.683 44.7493 43.4029 45.8323C44.1228 46.9154 45.148 47.7603 46.3487 48.2599C47.5494 48.7595 48.8714 48.8913 50.1471 48.6387C51.4228 48.386 52.5948 47.7602 53.5144 46.8406C54.434 45.921 55.0598 44.7491 55.3124 43.4734C55.5651 42.1976 55.4333 40.8756 54.9337 39.6749C54.4341 38.4743 53.5892 37.449 52.5061 36.7291ZM38.8201 23.0301C38.433 23.3234 38.1501 23.733 38.0126 24.1988L33.8689 37.5226H40.7751H40.9451C41.8943 35.9715 43.2753 34.7308 44.9189 33.9526L42.2839 24.1988C42.1134 23.7634 41.8236 23.3849 41.4477 23.1067C41.0718 22.8286 40.6251 22.6621 40.1589 22.6263C39.6798 22.606 39.208 22.7483 38.8201 23.0301ZM39.9251 40.2001H33.1251L31.2976 45.7038H40.3289C39.8926 44.6308 39.6689 43.4834 39.6701 42.3251C39.6778 41.6096 39.7633 40.8971 39.9251 40.2001ZM30.4476 48.4451L28.6414 54.2888L49.9551 54.3526L49.1689 51.6751H48.9139C47.5875 51.6735 46.2773 51.3839 45.0738 50.8262C43.8704 50.2685 42.8025 49.4561 41.9439 48.4451C41.8386 48.4652 41.7304 48.4652 41.6251 48.4451H30.4476ZM47.4689 45.3214C47.3211 45.2612 47.19 45.1665 47.0864 45.0452L45.6839 43.6214C45.5759 43.5164 45.4901 43.3909 45.4315 43.2522C45.3729 43.1135 45.3427 42.9645 45.3427 42.8139C45.3427 42.6633 45.3729 42.5143 45.4315 42.3756C45.4901 42.2369 45.5759 42.1114 45.6839 42.0064C45.9012 41.7963 46.1892 41.675 46.4914 41.6664C46.6418 41.6663 46.7908 41.6963 46.9295 41.7547C47.0682 41.8131 47.1938 41.8987 47.2989 42.0064L47.5964 42.3252C47.6342 42.3664 47.6802 42.3993 47.7314 42.4218C47.7826 42.4443 47.8379 42.4559 47.8939 42.4559C47.9498 42.4559 48.0051 42.4443 48.0564 42.4218C48.1076 42.3993 48.1535 42.3664 48.1914 42.3252L51.1664 39.4989L51.4639 39.2014C51.6031 39.1339 51.7554 39.0977 51.9101 39.0952C52.0655 39.0961 52.2191 39.1286 52.3616 39.1907C52.504 39.2528 52.6324 39.3432 52.7389 39.4564C52.8466 39.5615 52.9322 39.687 52.9906 39.8257C53.049 39.9644 53.079 40.1134 53.0789 40.2639C53.0703 40.5661 52.949 40.8541 52.7389 41.0714L48.6376 45.0239L48.3401 45.3214C48.1927 45.3495 48.0413 45.3495 47.8939 45.3214C47.7534 45.3479 47.6093 45.3479 47.4689 45.3214Z" fill="#213F5F"></path>
            <defs>
              <clipPath id="clip0_1425_28169">
                <rect width="77" height="77" fill="white" transform="translate(0 77) rotate(-90)"></rect>
              </clipPath>
            </defs>
          </svg></div>
        <p class="MuiTypography-root jss148 MuiTypography-body2">Motor vehicle records check</p>
      </div>
      <div role="button" class="jss146">
        <div class="jss147"><svg width="77" height="77" viewBox="0 0 77 77" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clip-path="url(#clip0_1609_203024)">
              <path d="M0 44.7957C0 24.0086 17.0459 1.99866 42.0266 1.38747C67.0073 0.776282 76.9557 22.7607 77 39.2931C77.0496 57.9401 65.5968 75.576 43.4063 75.6246C23.8055 75.6679 0 65.5828 0 44.7957Z" fill="#FFF1EB"></path>
            </g>
            <path fill-rule="evenodd" clip-rule="evenodd" d="M29.8341 58.7314L31.5255 53.2601C31.5437 53.2609 31.5619 53.2614 31.5801 53.2614H42.1244C42.503 53.6484 42.9116 54.0072 43.347 54.334C43.3708 54.3575 43.3956 54.3799 43.4216 54.4012C44.9436 55.5358 46.7364 56.2406 48.6129 56.4501L49.2271 58.7314H29.8341ZM50.8947 56.4041L51.5347 58.7314H54.9175C55.212 58.7314 55.4944 58.8484 55.7026 59.0566C55.9108 59.2649 56.0278 59.5473 56.0278 59.8417C56.0278 60.1362 55.9108 60.4186 55.7026 60.6268C55.4944 60.8351 55.212 60.952 54.9175 60.952H50.7016L50.6854 60.9524H28.3314L28.3216 60.9523L28.3053 60.952H24.0957C23.8012 60.952 23.5188 60.8351 23.3106 60.6268C23.1023 60.4186 22.9854 60.1362 22.9854 59.8417C22.9854 59.5473 23.1023 59.2649 23.3106 59.0566C23.5188 58.8484 23.8012 58.7314 24.0957 58.7314H27.496L29.8952 51.0218L28.2192 49.9306C26.2902 48.6754 24.7064 46.9569 23.6125 44.932C22.5186 42.9072 21.9495 40.6405 21.9571 38.3391V25.5558C21.9565 25.4018 21.9878 25.2493 22.0489 25.1079C22.1101 24.9665 22.1998 24.8393 22.3124 24.7342C22.4246 24.6313 22.5567 24.5526 22.7006 24.503C22.8445 24.4533 22.9971 24.4338 23.1488 24.4455C33.5985 25.264 38.8625 19.1818 39.3898 18.5726L39.3898 18.5726C39.4156 18.5427 39.4301 18.526 39.4332 18.524C39.5266 18.3974 39.6466 18.2927 39.7846 18.2173C39.9227 18.1418 40.0756 18.0975 40.2326 18.0872C40.3896 18.0757 40.5472 18.0974 40.6951 18.151C40.8431 18.2046 40.9781 18.2888 41.0912 18.3981C43.2376 20.4807 45.7937 22.0938 48.5973 23.1349C51.4008 24.176 54.3903 24.6224 57.3756 24.4455C57.5374 24.4276 57.7012 24.4448 57.8557 24.4959C58.0103 24.547 58.152 24.6308 58.2713 24.7416C58.391 24.8534 58.4844 24.9904 58.5446 25.1428C58.6047 25.2952 58.6302 25.459 58.6192 25.6225L57.7253 38.6727C58.5639 39.6152 59.2346 40.7048 59.6988 41.8954C60.5444 44.0642 60.6589 46.4498 60.0248 48.6896C59.3907 50.9294 58.0428 52.901 56.1858 54.3047C54.6386 55.4742 52.8086 56.1963 50.8947 56.4041ZM46.2407 53.5101C46.2883 53.5214 46.336 53.5371 46.3834 53.5576C47.4394 54.015 48.5784 54.2494 49.7291 54.246C51.5747 54.2486 53.3706 53.6481 54.8435 52.5359C56.3164 51.4238 57.3856 49.8609 57.8884 48.0852C58.3912 46.3094 58.3001 44.418 57.6289 42.6987C57.2157 41.6403 56.5966 40.6828 55.8146 39.8778C55.8018 39.8661 55.7891 39.854 55.7768 39.8417C54.4158 38.4648 52.6232 37.5973 50.699 37.3844C48.7747 37.1715 46.8358 37.6261 45.2068 38.6722C45.155 38.7055 45.1007 38.7345 45.0445 38.7587C43.9464 39.4902 43.034 40.469 42.381 41.6172C41.7019 42.8113 41.3237 44.1529 41.2793 45.5259C41.2348 46.8989 41.5254 48.2621 42.1258 49.4977C42.7142 50.7084 43.5828 51.7609 44.659 52.5681C44.6871 52.5834 44.7147 52.5999 44.7416 52.6178C45.2117 52.9677 45.7144 53.2662 46.2407 53.5101ZM41.2253 31.4257C40.8735 31.1883 40.4582 31.061 40.0328 31.061C39.5862 31.061 39.151 31.2012 38.7884 31.4618C38.4258 31.7225 38.1543 32.0904 38.012 32.5137L34.4907 43.7573H39.2742C39.4552 42.8248 39.7604 41.9175 40.184 41.0602C40.9216 39.5678 41.9977 38.2684 43.3266 37.2658L42.0165 32.5137C41.8806 32.0828 41.6105 31.7067 41.2456 31.4403L41.2253 31.4257ZM39.0802 45.9779H33.9335C33.888 45.9779 33.8427 45.9751 33.7979 45.9696L32.3475 50.6009L32.3009 50.7511C32.2905 50.7941 32.2774 50.8366 32.2618 50.8783L32.2116 51.0408H40.4571C40.3841 50.9115 40.3138 50.7805 40.2462 50.648C39.507 49.1998 39.1085 47.6025 39.0802 45.9779ZM29.4331 48.0727L30.5747 48.8092L35.8589 31.7809C35.972 31.4495 36.1239 31.135 36.31 30.843C36.6108 30.3632 37.0041 29.9437 37.4707 29.6109C38.2235 29.0741 39.1277 28.7909 40.0522 28.8024C40.9767 28.814 41.8736 29.1197 42.6127 29.6752C43.3518 30.2307 43.8949 31.0071 44.1631 31.8919L45.3178 36.0889C46.9599 35.3295 48.7678 34.9991 50.5724 35.1285C52.377 35.258 54.1192 35.8431 55.6362 36.8291L56.2801 26.6958C50.425 26.7614 44.7539 24.6513 40.3659 20.7742C38.4413 22.7061 33.1637 27.051 24.1777 26.7254V38.3391C24.1712 40.2713 24.6487 42.1744 25.5667 43.8747C26.4847 45.5749 27.814 47.0182 29.4331 48.0727ZM48.7445 49.3014C48.468 49.2917 48.2048 49.1811 48.0043 48.9906L46.2204 47.2437C46.1165 47.1411 46.0341 47.0189 45.9778 46.8842C45.9216 46.7496 45.8926 46.605 45.8926 46.4591C45.8926 46.3131 45.9216 46.1686 45.9778 46.0339C46.0341 45.8992 46.1165 45.777 46.2204 45.6745C46.4295 45.4683 46.7114 45.3528 47.005 45.3528C47.2986 45.3528 47.5805 45.4683 47.7896 45.6745L48.8037 46.6663L52.897 42.6323C53.107 42.4251 53.3908 42.31 53.6857 42.312C53.9807 42.3141 54.2628 42.4333 54.4699 42.6434C54.677 42.8534 54.7922 43.1371 54.7901 43.4321C54.788 43.7271 54.6689 44.0092 54.4588 44.2163L49.5809 49.0054C49.4698 49.1103 49.338 49.1909 49.194 49.2419C49.0499 49.2929 48.8968 49.3132 48.7445 49.3014Z" fill="#213F5F"></path>
            <defs>
              <clipPath id="clip0_1609_203024">
                <rect width="77" height="77" fill="white"></rect>
              </clipPath>
            </defs>
          </svg></div>
        <p class="MuiTypography-root jss148 MuiTypography-body2">Investigative criminal plus check</p>
      </div>
    </div>
  </div>
</div>
<div class="jss95 jss153"><svg width="1440" height="85" viewBox="0 0 1440 85" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
    <path d="M7.89135e-06 40.2672C7.89135e-06 40.2672 222.113 -19.0729 720 40.2671C1293.5 108.619 1440 0.000606533 1440 0.000606533L1440 179.884L1.57259e-05 179.884L7.89135e-06 40.2672Z" class="jss96 jss154"></path>
  </svg></div>
<div>
  <!-- <div data-testid="value-drivers-options" class="jss156">
    <div class="jss157">
      <div class="jss158">
        <h2 class="MuiTypography-root jss40 jss159 MuiTypography-body1">Leading in care for over 15 years</h2>
        <div class="jss160">
          <div class="jss161">
            <div class="jss162"><svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M27.2599 39.57C26.7939 39.5712 26.3299 39.5106 25.8799 39.39C24.7639 39.0307 23.7258 38.4642 22.8199 37.72L22.3799 37.4C21.3799 36.69 20.3799 35.93 19.3799 35.06C19.1769 34.8882 18.9754 34.7149 18.7754 34.5401C16.842 35.8475 14.4612 36.62 11.8897 36.62C10.7677 36.6213 9.65083 36.4699 8.56969 36.17C8.49534 36.1773 8.42358 36.2013 8.35969 36.24L6.87969 37.08C6.03884 37.5449 5.05873 37.6916 4.11859 37.4933C3.17846 37.295 2.34112 36.7649 1.75969 36C1.39454 35.5092 1.14997 34.9394 1.04574 34.3366C0.941511 33.7338 0.980544 33.1149 1.15969 32.53L1.56969 31.14C1.58096 31.0671 1.58096 30.9929 1.56969 30.92C0.664173 29.3653 0.184716 27.5992 0.179688 25.8C0.179688 20.7956 3.86873 16.5923 8.8554 15.3576C9.58472 13.32 10.9197 11.5462 12.6899 10.28C14.2227 9.22251 16.012 8.59729 17.8699 8.47C20.2572 8.26492 22.6436 8.87473 24.6399 10.2C24.8414 10.3296 25.0326 10.4747 25.2246 10.6204L25.2246 10.6204L25.2247 10.6205L25.2255 10.6211C25.2999 10.6776 25.3745 10.7342 25.4499 10.79L25.9599 11.17C26.1647 11.3194 26.3785 11.4564 26.5999 11.58L26.8199 11.69H26.8999C27.0106 11.7368 27.1296 11.7608 27.2499 11.7608C27.3701 11.7608 27.4891 11.7368 27.5999 11.69H27.6599L27.8899 11.59C28.1139 11.4617 28.3309 11.3215 28.5399 11.17L29.0499 10.78C29.3199 10.58 29.5899 10.38 29.8599 10.2C31.8561 8.87473 34.2425 8.26492 36.6299 8.47C38.4843 8.59905 40.2699 9.22419 41.7999 10.28C43.5271 11.5169 44.8482 13.2387 45.5959 15.2273C46.3436 17.2158 46.4842 19.3815 45.9999 21.45C45.2177 24.6076 42.8411 27.2617 40.8509 29.4843L40.6399 29.72L40.4799 29.89C38.8192 31.7325 37.0351 33.4598 35.1399 35.06C34.1399 35.93 33.1399 36.69 32.1399 37.4L31.6999 37.72C30.7967 38.4682 29.7578 39.0353 28.6399 39.39C28.1901 39.5119 27.7259 39.5725 27.2599 39.57ZM21.2899 32.77C21.2023 32.6949 21.115 32.6198 21.028 32.5446C22.6303 30.6912 23.5897 28.342 23.5897 25.79C23.5897 19.9248 18.5223 15.1695 12.2281 15.0044C12.7607 14.1014 13.4775 13.3114 14.3399 12.69C15.4337 11.9419 16.7077 11.5 18.0299 11.41C19.7413 11.254 21.455 11.6842 22.8899 12.63L23.5699 13.13L24.1499 13.56C24.4491 13.7763 24.7595 13.9765 25.0799 14.16C25.2181 14.24 25.3618 14.3101 25.5099 14.37L25.7199 14.46C26.6807 14.8556 27.759 14.8556 28.7199 14.46L28.9199 14.38C29.0638 14.3181 29.204 14.2479 29.3399 14.17C29.6649 13.9889 29.9788 13.7886 30.2799 13.57L30.8699 13.14C31.0899 12.97 31.3099 12.8 31.5399 12.64C32.9736 11.7 34.6821 11.2703 36.3899 11.42C37.7152 11.5096 38.9925 11.9515 40.0899 12.7C41.315 13.5962 42.2515 14.8308 42.7845 16.252C43.3175 17.6733 43.4236 19.2193 43.0899 20.7C42.4199 23.26 40.3199 25.62 38.4199 27.7L38.2599 27.87C36.7046 29.6102 35.0342 31.2438 33.2599 32.76C32.2899 33.57 31.3699 34.29 30.4199 34.95L29.9399 35.3C29.3283 35.809 28.6352 36.2114 27.8899 36.49C27.4873 36.6002 27.0625 36.6002 26.6599 36.49C25.9124 36.2095 25.2163 35.8074 24.5999 35.3L24.1199 34.95C23.2501 34.3393 22.4231 33.6772 21.5121 32.9479L21.512 32.9478L21.2899 32.77ZM11.8897 18C16.6897 18 20.5897 21.5 20.5897 25.82C20.5897 30.14 16.6897 33.65 11.8897 33.65C11.0382 33.6506 10.1906 33.5362 9.36969 33.31C9.10898 33.2385 8.84002 33.2015 8.56969 33.2C7.97956 33.2071 7.40112 33.3655 6.88969 33.66L5.39969 34.5C5.25524 34.578 5.09383 34.6192 4.92969 34.62C4.78142 34.614 4.63634 34.575 4.50499 34.506C4.37363 34.4369 4.25929 34.3395 4.17026 34.2208C4.08122 34.1021 4.01972 33.9651 3.99022 33.8196C3.96072 33.6742 3.96395 33.524 3.99969 33.38L4.41969 32C4.55695 31.5753 4.60471 31.1268 4.55996 30.6828C4.51521 30.2387 4.37892 29.8087 4.15969 29.42C3.51368 28.326 3.16867 27.0805 3.15969 25.81C3.15969 21.49 7.05969 17.99 11.8697 17.99L11.8897 18ZM8.28983 26.43C8.28983 27.1093 7.73914 27.66 7.05983 27.66C6.38052 27.66 5.82983 27.1093 5.82983 26.43C5.82983 25.7507 6.38052 25.2 7.05983 25.2C7.73914 25.2 8.28983 25.7507 8.28983 26.43ZM11.8797 27.66C12.559 27.66 13.1097 27.1093 13.1097 26.43C13.1097 25.7507 12.559 25.2 11.8797 25.2C11.2003 25.2 10.6497 25.7507 10.6497 26.43C10.6497 27.1093 11.2003 27.66 11.8797 27.66ZM17.9397 26.43C17.9397 27.1093 17.389 27.66 16.7097 27.66C16.0304 27.66 15.4797 27.1093 15.4797 26.43C15.4797 25.7507 16.0304 25.2 16.7097 25.2C17.389 25.2 17.9397 25.7507 17.9397 26.43Z" fill="#213F5F"></path>
              </svg></div>
            <div>
              <h2 class="MuiTypography-root jss163 MuiTypography-h2">Helping you find the right fit</h2>
              <div class="jss164">Explore profiles, send messages and read what other families have to say about
                caregivers.</div>
            </div>
          </div>
          <div class="jss161">
            <div class="jss162"><svg class="MuiSvgIcon-root jss166" focusable="false" viewBox="0 0 48 48" aria-hidden="true">
                <path fill="#213f5f" d="M22.29 43.44h-.52a1.3 1.3 0 0 1-.57-.2l-10.75-7A13.72 13.72 0 0 1 4.2 24.69V12.14a1.27 1.27 0 0 1 .41-.93 1.3 1.3 0 0 1 .95-.33c10.6.82 15.61-5.5 15.82-5.77A1.27 1.27 0 0 1 23.27 5a21 21 0 0 0 15.82 5.88 1.26 1.26 0 0 1 1.41 1.32l-.62 9.8A1.26 1.26 0 0 1 38 23a6.77 6.77 0 1 0-6.22 12 1.27 1.27 0 0 1 .21 2.21l-9 6a1.23 1.23 0 0 1-.7.23ZM13 34.88l9.08 5.9 6.76-4.56a9.3 9.3 0 0 1 5.55-16.77 9.12 9.12 0 0 1 3.06.53l.42-6.53a23.79 23.79 0 0 1-6.26-.85ZM6.72 13.47v11.22a11.21 11.21 0 0 0 4.2 8.76l18.14-21.71a23.14 23.14 0 0 1-6.6-4.07 21.06 21.06 0 0 1-15.74 5.8Z">
                </path>
                <path fill="#213f5f" d="M34.41 38.06a9.29 9.29 0 0 1-3.68-.76l1-2.32a6.66 6.66 0 0 0 2.68.55A6.77 6.77 0 0 0 38 23l1.33-2.15a9.3 9.3 0 0 1-4.87 17.22Z">
                </path>
                <path fill="#213f5f" d="M33.54 32a1.24 1.24 0 0 1-.88-.36l-1.5-1.46a1.26 1.26 0 0 1 1.76-1.81l.62.6 3.2-3.15a1.26 1.26 0 1 1 1.77 1.8l-4.09 4a1.21 1.21 0 0 1-.88.38Z">
                </path>
              </svg></div>
            <div>
              <h2 class="MuiTypography-root jss163 MuiTypography-h2">Prioritizing your safety</h2>
              <div class="jss164">100% of caregivers are background checked before being able to interact with
                families for added peace of mind.</div>
            </div>
          </div>
          <div class="jss161">
            <div class="jss162"><svg class="MuiSvgIcon-root jss167" focusable="false" viewBox="0 0 48 48" aria-hidden="true">
                <path fill="#213f5f" d="M29.83 26.9a3.59 3.59 0 0 1-.93-.12 5.89 5.89 0 0 1-2-1.08l-.26-.18c-.62-.43-1.23-.9-1.87-1.44a35.67 35.67 0 0 1-3.27-3.17l-.1-.11c-1.26-1.38-2.82-3.1-3.33-5.16a6.87 6.87 0 0 1 2.68-7.15 6.74 6.74 0 0 1 3.35-1.17 6.87 6.87 0 0 1 4.33 1.11l.5.37.31.23.35.23.14.06h.19l.15-.07.35-.25.31-.23.5-.37a6.82 6.82 0 0 1 4.33-1.11 6.7 6.7 0 0 1 3.31 1.17 6.88 6.88 0 0 1 2.69 7.15c-.51 2.06-2.07 3.78-3.33 5.16l-.1.11a34.5 34.5 0 0 1-3.28 3.17c-.64.54-1.25 1-1.86 1.44l-.26.19a6.22 6.22 0 0 1-2 1.07 3.46 3.46 0 0 1-.9.15ZM24.65 9.81h-.36a4.28 4.28 0 0 0-2.07.72A4.4 4.4 0 0 0 20.53 15c.36 1.45 1.63 2.85 2.76 4.08l.1.11a31.84 31.84 0 0 0 3 2.94c.58.49 1.13.91 1.69 1.31l.3.21a4.12 4.12 0 0 0 1.13.68 1.37 1.37 0 0 0 .57 0 4.16 4.16 0 0 0 1.14-.68l.29-.21c.56-.39 1.12-.82 1.7-1.31a31.84 31.84 0 0 0 3-2.94l.11-.11a10.81 10.81 0 0 0 2.8-4.08 4.37 4.37 0 0 0-1.68-4.49 4.37 4.37 0 0 0-4.8 0c-.14.09-.27.19-.4.29l-.36.27a6.33 6.33 0 0 1-.61.39l-.37.17a2.68 2.68 0 0 1-2.15 0l-.37-.17a6.17 6.17 0 0 1-.6-.39l-.36-.27c-.13-.1-.26-.2-.4-.29a4.18 4.18 0 0 0-2.37-.7Zm15.69 5.52Z">
                </path>
                <path fill="#213f5f" d="M26.31 40.61c-3 0-6.59-1.47-9.72-3-2.6-1.24-3.9-.4-5.27.49a4.17 4.17 0 0 1-3.44 1c-2.78-.73-4.08-3.45-3.57-7.45.62-4.88 3.69-7.65 9.16-8.34 4.81-.58 12 3.14 15.89 5.41a3.45 3.45 0 0 1 .91.78l7.64-5.42a3.7 3.7 0 0 1 5.86 3.47A3.65 3.65 0 0 1 42.31 30c-3.07 2.28-10.39 7.75-12.12 9.28a5.62 5.62 0 0 1-3.88 1.33ZM14.2 34.52a8.06 8.06 0 0 1 3.47.87c5.69 2.7 9.35 3.39 10.86 2C30.27 35.9 37 30.88 40.81 28a1.17 1.17 0 0 0 .47-.8 1.19 1.19 0 0 0-1.89-1.11L31.08 32a3.37 3.37 0 0 1-.44 1.48 3.51 3.51 0 0 1-4.4 1.52l-1.19-.49h-.1c-2-1-5.74-2.65-7.15-2.57a1.26 1.26 0 1 1-.15-2.51c2.52-.14 7.33 2.27 8.41 2.83l1.14.47a1 1 0 0 0 1.26-.43 1 1 0 0 0-.37-1.36c-2.9-1.7-10.08-5.6-14.32-5.09-5.56.66-6.65 3.65-7 6.19-.2 1.53-.24 4.19 1.72 4.71.28.07.73-.2 1.44-.66a7.51 7.51 0 0 1 4.27-1.57Z">
                </path>
              </svg></div>
            <div>
              <h2 class="MuiTypography-root jss163 MuiTypography-h2">Here when you need us</h2>
              <div class="jss164">Access our dedicated chat support team and care resources for premium members.
              </div>
            </div>
          </div>
        </div><button class="MuiButtonBase-root MuiButton-root MuiButton-contained jss165 MuiButton-containedPrimary MuiButton-containedSizeLarge MuiButton-sizeLarge" tabindex="0" type="button"><span class="MuiButton-label">Get started</span></button>
      </div>
    </div>
  </div> -->
</div>

@endsection